var _intervalVar = null;

function form_OnLoad() {
    if (Xrm.Page.ui.getFormType() != 1) { loadLOBForm(); }

    if (Xrm.Page.getAttribute("vhacrm_isassist_bool") != null) {
        Xrm.Page.getAttribute("vhacrm_isassist_bool").setSubmitMode("never");
    }

    if (Xrm.Page.getAttribute("vhacrm_dayssincelastcontact_text") != null) {
        Xrm.Page.getAttribute("vhacrm_dayssincelastcontact_text").setSubmitMode("always");
    }
    if (Xrm.Page.ui.getFormType() == 4) {
        Xrm.Page.getControl("WebResource_CompleteInteraction").setVisible(false);
        Xrm.Page.getControl("WebResource_completecasenote").setVisible(false);
        Xrm.Page.getControl("WebResource_mvisearch").setVisible(false);
        Xrm.Page.getControl("WebResource_CreateCorrespondence").setVisible(false);
        Xrm.Page.getControl("WebResource_sendformrequests").setVisible(false);

    }
    else {
        if (Xrm.Page.getAttribute("vhacrm_interactionno_text").getValue() && Xrm.Page.getAttribute("bah_veteranid").getValue()) {
            Xrm.Page.ui.tabs.get("tab_interactioninformation").sections.get("section_correspondencebutton").setVisible(true);
        }
        else {
            Xrm.Page.ui.tabs.get("tab_interactioninformation").sections.get("section_correspondencebutton").setVisible(false);
        }
    }

    //show/hide sections and tabs
    checkType();
    checkResolution();
    toggleResolutionSection(true);

    //check for subareas and templates
    checkSubareas();
    //checkTemplates();

    loadWebParts();
}

function form_OnSave(context) {
    preventAutoSave(context);
}

function firstname_OnChange() { refresh.firstname_OnChange(); }

function lastname_OnChange() { refresh.lastname_OnChange(); }

function dob_OnChange() { refresh.dob_OnChange(); }

function ssn_OnChange() { refresh.ssn_OnChange(); }

function edipi_OnChange() { refresh.edipi_OnChange(); }

function gender_OnChange() { refresh.gender_OnChange(); }

function daytimePhone_OnChange() { refresh.daytimePhone_OnChange(); }


function type_OnChange(context) {
    Xrm.Page.getAttribute("vhacrm_areaintersectionid").setValue(null);
    Xrm.Page.getAttribute("vhacrm_subareaintersectionid").setValue(null);
    Xrm.Page.getAttribute("vhacrm_resolutionintersectionid").setValue(null);
    Xrm.Page.getAttribute("vhacrm_casenotetemplateid").setValue(null);
    Xrm.Page.getAttribute("vhacrm_subareaintersectionid").setRequiredLevel("none");
    Xrm.Page.getAttribute("vhacrm_casenotetemplateid").setRequiredLevel("none");
    Xrm.Page.getAttribute("vhacrm_assist_casenotetemplateid").setValue(null);

    checkType();
    toggleResolutionSection(true);

    N52.Clientside.ExecuteFormulas(context, 'yDn');
}

function checkType() {
    //check for Disaster
    var typeValue = Xrm.Page.getAttribute("vhacrm_typeintersectionid").getValue();
    if (typeValue) {
        if (typeValue[0].name == "Disaster") {
            Xrm.Page.ui.tabs.get("tab_interactioninformation").sections.get("section_disaster").setVisible(true);
        }
        else {
            Xrm.Page.ui.tabs.get("tab_interactioninformation").sections.get("section_disaster").setVisible(false);
        }
    }
}

function checkVeteran() {
    if (Xrm.Page.getAttribute("bah_veteranid").getValue()) {
        Xrm.Page.ui.tabs.get("tab_interactioninformation").sections.get("section_veteraninfo").setVisible(true);
        Xrm.Page.ui.tabs.get("tab_interactioninformation").sections.get("section_veteraninfo_input").setVisible(false);
        Xrm.Page.ui.tabs.get("tab_interactioninformation").sections.get("section_correspondencebutton").setVisible(true);
        Xrm.Page.ui.tabs.get("tab_History").setDisplayState("expanded");
        Xrm.Page.ui.tabs.get("tab_veteransearch").setDisplayState("collapsed"); // change to collapse/expand
    }
    else {
        Xrm.Page.ui.tabs.get("tab_interactioninformation").sections.get("section_veteraninfo_input").setVisible(true);
        Xrm.Page.ui.tabs.get("tab_interactioninformation").sections.get("section_veteraninfo").setVisible(false);
        Xrm.Page.ui.tabs.get("tab_History").setDisplayState("collapsed");
        if (Xrm.Page.getAttribute("vhacrm_interactionno_text").getValue()) {
            Xrm.Page.ui.tabs.get("tab_veteransearch").setDisplayState("expanded");
        }
       
    }
}

function area_OnChange(context) {
    Xrm.Page.data.save().then(area_Callback(), function (err) { alert(err); });
}

function area_Callback() {
    checkSubareas();
    checkTemplates();
    toggleResolutionSection(true);
    Xrm.Page.getAttribute("vhacrm_subareaintersectionid").setValue(null);
    Xrm.Page.getAttribute("vhacrm_casenotetemplateid").setValue(null);
    Xrm.Page.getAttribute("vhacrm_assist_casenotetemplateid").setValue(null);
}

function subArea_OnChange() {
    var type = Xrm.Page.getAttribute("vhacrm_typeintersectionid").getValue();
    var area = Xrm.Page.getAttribute("vhacrm_areaintersectionid").getValue();

    // If W2VA, then resolution is cleared on sub area change
    if (type[0].name == "W2VA") {
        Xrm.Page.getAttribute("vhacrm_resolutionintersectionid").setValue(null);
    }
}

function resolution_OnChange(context) {
    //Xrm.Page.data.entity.save();
    checkResolution();
}

function checkResolution() {
    if (Xrm.Page.getAttribute("vhacrm_resolutionintersectionid").getValue()) {
        if (Xrm.Page.getAttribute("vhacrm_typeintersectionid").getValue()[0].name == "W2VA" && Xrm.Page.getAttribute("bah_facilityid").getValue() == null) {
            Xrm.Page.ui.setFormNotification("Please populate a Facility before completing this Interaction.", "WARNING", "facilityNotification")
        }
        Xrm.Page.ui.tabs.get("tab_interactioninformation").sections.get("section_complete").setVisible(true);

    }
    else {
        Xrm.Page.ui.tabs.get("tab_interactioninformation").sections.get("section_complete").setVisible(false);
    }
}

function toggleResolutionSection(changeEvent) {
    var type = Xrm.Page.getAttribute("vhacrm_typeintersectionid").getValue();
    var area = Xrm.Page.getAttribute("vhacrm_areaintersectionid").getValue();
    var res1Visible = Xrm.Page.ui.tabs.get("tab_interactioninformation").sections.get("section_resolution").getVisible();

    if (type != null && area != null && type[0].name == "W2VA") {
        if (res1Visible) {
            // Hide section with Resolution field that is filtered by Type and Show section with Resolution field that is filtered by Sub Area
            Xrm.Page.ui.tabs.get("tab_interactioninformation").sections.get("section_resolution").setVisible(false);
            Xrm.Page.ui.tabs.get("tab_interactioninformation").sections.get("section_resolutionbysubarea").setVisible(true);

            if (changeEvent) {
                Xrm.Page.getAttribute("vhacrm_resolutionintersectionid").setValue(null);
            }
        }
    }
    else {
        if (!res1Visible) {
            // Hide section with Resolution field that is filtered by Sub Area and Show section with Resolution field that is filtered by Type
            Xrm.Page.ui.tabs.get("tab_interactioninformation").sections.get("section_resolutionbysubarea").setVisible(false);
            Xrm.Page.ui.tabs.get("tab_interactioninformation").sections.get("section_resolution").setVisible(true);

            if (changeEvent) {
                Xrm.Page.getAttribute("vhacrm_resolutionintersectionid").setValue(null);
            }
        }
    }

}

function caseNoteTemplate_OnChange(context) {
    appendTemplateText();
}

function loadWebParts() {
    unattendedSearchFromRelatedRecord("bah_veteranid", loadAssociations, loadESRWebParts);
    checkVeteran();
}

function loadAssociations(icn) {
    displayWebPart(icn, 'IFRAME_associations', 'esr_associations_endpoint');
}

function loadESRWebParts(icn) {
    //pass icn, folder path and list of control names/resource names to the loadEsrResources function
    loadEsrResources(icn, '/webresources/vhacrm_/ESRParts', 'WebResource_enrollment|enrollment.htm,WebResource_esreligibility|eligibility.htm,WebResource_demographics|demographics.htm');
}

function availableforms_OnChange() { Xrm.Page.data.entity.save(); }

// If there is only one Sub Area, make it the default
function checkSubareas() {
    var areaintersectionid = Xrm.Page.getAttribute("vhacrm_areaintersectionid").getValue();
    if (areaintersectionid) {
        var oDataSetName = "vhacrm_subareaintersection";
        var filter = "vhacrm_areaintersectionid/Id eq (guid'" + areaintersectionid[0].id.toString() + "') and statecode/Value eq 0";
        var columns = "*";
        var querystring = "$select=" + columns + "&$filter=" + filter;
        SDK.REST.retrieveMultipleRecords(
			oDataSetName,
			querystring,
			function (data) {
			    if (data.length > 0) {
			        Xrm.Page.getAttribute('vhacrm_subareaintersectionid').setRequiredLevel('required');
			    }
			    else {
			        Xrm.Page.getAttribute('vhacrm_subareaintersectionid').setRequiredLevel('none');
			    }
			},
			function (error) {
			    alert(error);
			    //do nothing
			},
			function () {
			    //do nothing on completion
			}
		);
    }
}

// If there is only one Case Note Template, make it the default
function checkTemplates() {
    var areaintersectionid = Xrm.Page.getAttribute("vhacrm_areaintersectionid").getValue();
    var existingcasenotetext = Xrm.Page.getAttribute("vhacrm_casenotes_memo").getValue();

    if (areaintersectionid && existingcasenotetext == null) {
        var oDataSetName = "vhacrm_casenotetemplate";
        var filter = "vhacrm_areaintersectionid/Id eq (guid'" + areaintersectionid[0].id.toString() + "') and statecode/Value eq 0";
        var columns = "*";
        var querystring = "$select=" + columns + "&$filter=" + filter;
        SDK.REST.retrieveMultipleRecords(
			oDataSetName,
			querystring,
			function (data) {
			    if (data.length > 0) {
			        Xrm.Page.getAttribute('vhacrm_casenotetemplateid').setRequiredLevel('required');
			        if (data.length == 1) {
			            var lookupReference = [];
			            lookupReference[0] = {};
			            lookupReference[0].id = data[0].vhacrm_casenotetemplateId;
			            lookupReference[0].entityType = 'vhacrm_casenotetemplate';
			            lookupReference[0].name = data[0].vhacrm_name;

			            Xrm.Page.getAttribute("vhacrm_casenotetemplateid").setValue(lookupReference);

			            var casenotetext = data[0].vhacrm_template_memo;
			            if (casenotetext) {
			                if (existingcasenotetext) {
			                    casenotetext = existingcasenotetext + "\r\n------------\r\n" + casenotetext;
			                    Xrm.Page.getAttribute("vhacrm_casenotes_memo").setValue(casenotetext);
			                }
			                else {
			                    Xrm.Page.getAttribute("vhacrm_casenotes_memo").setValue(casenotetext);
			                }
			            }
			        }
			        Xrm.Page.getAttribute("vhacrm_temp_text").setValue(null);
			    }
			    else {
			        Xrm.Page.getAttribute('vhacrm_casenotetemplateid').setRequiredLevel('none');
			        Xrm.Page.getAttribute('vhacrm_casenotes_memo').setRequiredLevel('none');
			    }
			},
			function (error) {
			    //do nothing
			    alert(error);
			},
			function () {
			    //do nothing on completion
			}
		);
    }
}

function appendTemplateText() {
    var templateid = Xrm.Page.getAttribute("vhacrm_casenotetemplateid").getValue();
    var existingcasenotetext = Xrm.Page.getAttribute("vhacrm_casenotes_memo").getValue();

    if (templateid) {
        SDK.REST.retrieveRecord(
			templateid[0].id.toString(),
			"vhacrm_casenotetemplate",
			"vhacrm_template_memo",
			null,
			function (data) {
			    var casenotetext = data.vhacrm_template_memo;
			    if (casenotetext) {
			        if (existingcasenotetext) {
			            casenotetext = existingcasenotetext + "\r\n------------\r\n" + casenotetext;
			        }
			        Xrm.Page.getAttribute("vhacrm_casenotes_memo").setValue(casenotetext);
			    }
			    Xrm.Page.getAttribute("vhacrm_temp_text").setValue(null);
			},
			function (error) {
			    //do nothing
			    alert(error);
			}
		);
    }
}
